/////////////////////////////////////////////////////////////////
// All General and Map Specific Tasks and Triggers for Mainmap //
/////////////////////////////////////////////////////////////////
$map1FinalQuest = "Pack Your Bags";
// Temp clickpopup tasks to trigger satellite maps on Mainmap

function MainmapTriggers::onEnter()
{
   // completes vertex
   TaskModifier.strMarkVertex("MainmapTasks", "MainmapTriggers", $TSV_CMPLETE);
}

// Used only when the tutorial is skipped

function Tutorialskip::onEnter()
{
   // Unlock Goldmine and Woodhut
   tsActivateBuildingXP("Goldmine");
   tsActivateBuildingXP("Woodhut");
   XPBuyGoldmine.reqCheck0 = true;
   XPBuyWoodhut.reqCheck0 = true;
   tsEnableCommand(ProduceSheepCmdData, false);
   
   // Set XP
   IncreaseExperience(12);
   
   //Set Starting resources
   tsModifyResource($Resource::gold, 400, true);
   tsModifyResource($Resource::wood, 400, true);
   
   // complete vertex
   TaskModifier.strMarkVertex("MainmapTasks", "Tutorialskip", $TSV_CMPLETE);
   // temp test
   //TaskModifier.strMarkVertex("MainmapTasks", "FinalTaskMap1", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "StoryArcTrigger", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "DisasterslowTrigger", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "BoomTownStart", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "strandeddelay", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "HopeRefugeesIntro", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "HopeRescueTrigger", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "Dualbanditintro", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "BanditWarnIntro", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "MainmapDeadmineTrigger", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "DisasterFireDialog", $TSV_AVAIL);
   //TaskModifier.strMarkVertex("MainmapTasks", "BadSeedMapStart", $TSV_AVAIL);
   
   // Adds bonus character if Sandbox Disaster Award is awarded
   if(tsIsBadgeAwarded("badge_sandboxchallenge"))
   {
      //Spawn Sasquatch
      %obj = tsCreateObj("Sasquatch", "", $OST_PLAYER, "-398 -374");
      tsSendTaskPopUpDlg("ID_SasquatchAward", "id_sassybadge", $TaskButton::Okay, %obj); 
   }
}

/////////////////////////////////////////////////////////////////
//Platform Unlock task 
/////////////////////////////////////////////////////////////////

//Trigger zone
function PlatformTriggerZone::onMessage(%this, %msg, %params)
{
   // Get id of character that triggered zone
   Parent::onMessage(%this, %msg, %params);
   if(%this.isMarkedComplete())
   {
      %objlist = tsGetObjListFromMsg(%msg, %params);
      %charID = %objlist.getID(0);

      %dlgData1 = tsCreateTaskDlgData("ID_Platform", false, $TaskButton::More);
      tsAddTaskDialog("ID_PlatformDude", %dlgData1);
      tsSendTaskDlgMsg(%dlgData1, platformdude);
      tsDestroyTaskDlgData(%dlgData1);
      %dlgData2 = tsCreateTaskDlgData("ID_Platform", false, $TaskButton::More);
      tsAddTaskDialog("ID_Platformone", %dlgData2);
      tsSendTaskDlgMsg(%dlgData2, %charID);
      tsDestroyTaskDlgData(%dlgData2);
      %dlgData3 = tsCreateTaskDlgData("ID_Platform", false, false);
      tsAddTaskDialog("ID_Platformtwo", %dlgData3);
      tsSendTaskDlgMsg(%dlgData3, platformdude);
      tsDestroyTaskDlgData(%dlgData3);
      
      // Quest log
      tsAddQuestToTracker(true, "Trade Route", "", "The trade route is blocked by large boulders.  Clear these boulders and build a new Outpost.", "Reward: 10 Experience");
      tsReadyQuest("Trade Route");
      tsAddTaskToTracker("Trade Route", "Clear the trail of boulders.", "Dynamite the large boulders to the east.");
      
      if(trackrock1.getName() $= "trackrock1")
      {
         TaskModifier.strMarkVertex("MainmapTasks", "Rockblast", $TSV_AVAIL);
      }
      else
      {
         TaskModifier.strMarkVertex("MainmapTasks", "Rockblast", $TSV_CMPLETE);
      }
      if(trackrock2.getName() $= "trackrock2")
      {
         TaskModifier.strMarkVertex("MainmapTasks", "Rockblast2", $TSV_AVAIL);
      }
      else
      {
         TaskModifier.strMarkVertex("MainmapTasks", "Rockblast2", $TSV_CMPLETE);
      }
   }
}
function Rockblasttext::onExit()
{
   %dlgData1 = tsCreateTaskDlgData("ID_Platform", false, false);
   tsAddTaskDialog("ID_rockblast", %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, platformdude);
   tsDestroyTaskDlgData(%dlgData1);
}
function Rockblast2text::onExit()
{
   %dlgData1 = tsCreateTaskDlgData("ID_Platform", false, false);
   tsAddTaskDialog("ID_rockblast", %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, platformdude);
   tsDestroyTaskDlgData(%dlgData1);
}
// Vertex completes on destroy of trackrock2 and trackrock1
function Platformunlock::onExit(%this)
{
   // Spawn 2 neutral civs 
   %char1obj = tsCreateObj("FemaleCiv", "platformciv1", $OST_NEUTRAL, "-257 -185");
   tsSkinObj("platformciv1", "default");
   %char1obj.name = "Betsy Smith";
   
   %char2obj = tsCreateObj("maleCiv", "platformciv2", $OST_NEUTRAL, "-257 -179");
   tsSkinObj("platformciv2", "default");
   %char2obj.name = "Wilbur Smith";
   
   tsSendTaskPopUpDlg("ID_Platform", "ID_Platformguns", $TaskButton::More, "platformciv1", "ID_Platformguns");
   tsSendTaskPopUpDlg("ID_Platform", "ID_PlatformOpenroad", $TaskButton::More, "herocharacter", "ID_Platformguns");
   tsSendTaskPopUpDlg("ID_Platform", "ID_PlatformNewcabin", $TaskButton::Okay, "platformciv2", "ID_Platformguns");
   
   //Quest log
   tsAddTaskToTracker("Trade Route", "Build the Smiths a new Cabin.", "The Smiths need a new Cabin away from the wagon trail.");
   tsCompleteTaskInTracker("Trade Route", "Clear the trail of boulders.");
}
// Vertex Completes on create logcabin 
function Platformcabin::onMessage(%this, %msg, %params)
{
   // Get id of character that triggered zone
   Parent::onMessage(%this, %msg, %params);
   if(%this.isMarkedComplete())
   {
      %objlist = tsGetObjListFromMsg(%msg, %params);
      %cabinID = %objlist.getID(0);
      if(%cabinID.isInZone(wagonroadzone))
      {
         //Too close to the road
         tsSendTaskPopUpDlg("ID_Platform", "ID_PlatformcabinReject", $TaskButton::Okay, "platformciv1", "ID_PlatformcabinReject");
         Platformcabinreset();
      }
      else
      {
         tsConvertObjTeam(%cabinID, 0);
         %cabinID.setName("smithcabin");
         %cabinID.name = "Smith's Home";
         TaskModifier.strMarkVertex("MainmapTasks", "Platformcabindelay", $TSV_AVAIL);
      }
   }
}
function Platformcabinreset()
{
   TaskModifier.strResetVertex("MainmapTasks", "Platformcabin");
   TaskModifier.strMarkVertex("MainmapTasks", "Platformcabin", $TSV_AVAIL);
}
function Platformcabindelay::onExit()
{
   tsSendTaskPopUpDlg("ID_Platform", "ID_Platformbuiltcabin", $TaskButton::More, "platformciv1", "ID_Platformbuiltcabin");  
   // Move
   tsMoveObjToTarget("platformciv1", "smithcabin");
   tsMoveObjToTarget("platformciv2", "smithcabin");
   //TODO: Reposition them spawn flower pot
}
// Vertex Completes on dialog:  
function Platformupgrade::onExit()
{
   tsConvertObjTeam("mapplatform", $OST_PLAYER);
   tsSendTaskPopUpDlg("ID_Platform", "ID_Platformunlock", $TaskButton::Okay, "platformdude", "ID_Platformunlock");  
   // Quest log
   tsAddTaskToTracker("Trade Route", "Build a new Outpost.", "Select the destroyed outpost platform and build a new Outpost.");
   tsCompleteTaskInTracker("Trade Route", "Build the Smiths a new Cabin.");
   
   // Start Outpost Resource Tasks
   slgActivateTask("OutpostTasks", true);
   TaskModifier.strMarkVertex("OutpostTasks", "OutpostTaskInit", $TSV_AVAIL);
   //Enable Badge Task: Central Hub
   TaskModifier.strMarkVertex("Badgetasks", "BadgeHubMissions", $TSV_AVAIL);
}
// Vertex Completes on Create Outpost
function BuildOutpost::onExit(%this)
{

   tsSendTaskPopUpDlg("ID_Platform", "ID_Platformoutpost", $TaskButton::Okay, "platformdude", "ID_Platformoutpost"); 
      
   // Quest log
   tsCompleteTaskInTracker("Trade Route", "Build a new Outpost.");
   // Reward
   tsModifyResource($Resource::Experience, 10, true);
   SendProductionToClient(HeroCharacter, "10 experience");
}
// Vertex completes after dialog: ID_Platformoutpost
function EmployOutpost::onExit()
{
   tsConvertObjTeam("platformdude", $OST_PLAYER);
   tsSkinObj("platformdude", "base");
   slgEmployObject(platformdude.getId(), mapPlatform.getId());
}

/////////////////////////////////////////////////////////////////
// Hope River Refugees 
/////////////////////////////////////////////////////////////////

function HopeRefugeesIntro::onExit()
{
   tsCreateObj("FemaleCiv", "civ1", $OST_NEUTRAL, "-463 -285");
   tsSkinObj("civ1", "default");
   tsNameObj("civ1", "Phaedra Dunnaway");
   tsCreateObj("FemaleCiv", "civ2", $OST_NEUTRAL, "-466 -285");
   tsSkinObj("civ2", "default");
   tsNameObj("civ2", "Emma Whiler");
   tsCreateObj("MaleCiv", "civ4", $OST_NEUTRAL, "-466 -281");
   tsSkinObj("civ4", "default");
   tsNameObj("civ4", "Israel Creedy");
   TaskModifier.strMarkVertex("MainmapTasks", "HopeRefugeesIntro", $TSV_CMPLETE); 
}
function RefugeesTalk::onExit()
{
   tsMoveObjToTarget("civ1", "-393 -291");
   tsMoveObjToTarget("civ2", "-392 -294");
   tsMoveObjToTarget("civ4", "-389 -292");
   %dlgData1 = tsCreateTaskDlgData("ID_Refugee", true, false, "ID_Refugeehelp");
   tsAddTaskDialog("ID_Refugeehelp", %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, "civ4");
   tsDestroyTaskDlgData(%dlgData1);
   TaskModifier.strMarkVertex("MainmapTasks", "RefugeesTalk", $TSV_CMPLETE);
   
   // Start Gunslinger Warning Trigger
   TaskModifier.strMarkVertex("MainmapTasks", "BanditWarnIntro", $TSV_AVAIL); 
}
function RefugeesTalk2::onExit()
{
   %dlgData1 = tsCreateTaskDlgData("ID_Refugee", false, $TaskButton::More);
   tsAddTaskDialog("ID_Refugeehelp1", %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, "civ1");
   tsDestroyTaskDlgData(%dlgData1);
   %dlgData1 = tsCreateTaskDlgData("ID_Refugee", false, false, "ID_Refugeehelp2");
   tsAddTaskDialog("ID_Refugeehelp2", %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, herocharacter.getID());
   tsDestroyTaskDlgData(%dlgData1);
}
function HopeRefugeesJoin::onExit()
{
   tsConvertObjTeam("civ1", $OST_PLAYER);
   tsSkinObj("civ1", "base");
   tsConvertObjTeam("civ2", $OST_PLAYER);
   tsSkinObj("civ2", "base");
   %dlgData1 = tsCreateTaskDlgData("ID_Refugee", false, $TaskButton::More);
   tsAddTaskDialog("ID_Refugeefood", %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, "civ4");
   tsDestroyTaskDlgData(%dlgData1);
   %dlgData = tsCreateTaskDlgData("ID_Refugee", false, $TaskButton::Okay);
   tsAddTaskDialog("ID_Refugeeherohelp", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
   %dlgData = tsCreateTaskDlgData("ID_Refugee", true, true, "ID_Refugeefoodaccept" );
   tsAddTaskDialog("ID_Refugeefoodaccept", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsAddAcceptCost($Resource::Food, 50, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "civ4");
   tsDestroyTaskDlgData(%dlgData);
      
   // Quest log
   tsAddQuestToTracker(true, "Hope River Refugees", "", "Collect 50 food for the townsfolk of Hope River", "Reward: 15 Experience");
   tsReadyQuest("Hope River Refugees");
   tsAddTaskToTracker("Hope River Refugees", "Give 50 Food to Israel Creedy.", "Gather 50 Food to give to Israel Creedy for the townsfolk of Hope River.");
   
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience");
   
}
function HopeGiveFood::onExit()
{
   %dlgData = tsCreateTaskDlgData("ID_Refugee", false, false, "ID_Refugeefoodgive" );
   tsAddTaskDialog("ID_Refugeefoodgive", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "civ4");
   tsDestroyTaskDlgData(%dlgData);
}
function HopeRefugeeEnd::onExit()
{
  tsMoveObjToTarget("civ4", "-466 -285");
  tsRemoveObj("civ4");
  
  // Start Hope Rescue Trigger
  TaskModifier.strMarkVertex("MainmapTasks", "HopeRescueTrigger", $TSV_AVAIL);
  // Quest log
  tsCompleteTaskInTracker("Hope River Refugees", "Give 50 Food to Israel Creedy.");
  //reward
  tsModifyResource($Resource::Experience, 15, true);
  SendProductionToClient(HeroCharacter, "15 experience");
}

////////////////////////////////////////////////////////////////////////////////
// Hope River Rescue
////////////////////////////////////////////////////////////////////////////////
// Starts after Hope River Refugees Complete and 300 secs
function HopeRescueTrigger::onExit()
{
   tsCreateObj("MaleCiv", "civ4", "0", "-464 -280", "civ4");
   tsNameObj("civ4", "Israel Creedy");
   tsSkinObj("civ4", "default");
}
function HopeRescueMoveDelay::onExit()
{
   tsMoveObjToTarget("civ4", "-387 -303");
   tsSendTaskClickDlg("ID_TASK_HopeRescue", "id_hoperescue_start", $TaskButton::Okay, "civ4", "id_hoperescue_start");
}
// Vertex completes after dialog: id_hoperescue_start
function HopeRescueHero::onExit()
{   
   tsSendTaskPopUpDlg("ID_TASK_HopeRescue", "id_hoperescue_hero", $TaskButton::More, "herocharacter", "id_hoperescue_hero");
   tsSendTaskPopUpDlg("ID_TASK_HopeRescue", "id_hoperescue_directions", $TaskButton::Okay, "civ4", "id_hoperescue_directions");
}
// Vertex completes after dialog: id_hoperescue_directions
function HopeRescueAccept::onExit()
{   
   %dlgData = tsCreateTaskDlgData("ID_TASK_HopeRescue", true, true, "id_hoperescue_accept");
   tsAddTaskDialog("id_hoperescue_accept", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "civ4");
   tsDestroyTaskDlgData(%dlgData);
}
// Checks to see if the Player has enough combat units for this map
function EnoughCombatCheck::onExit()
{ 
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %resourceCount = rsGetResourceCount($Resource::People);
   
   %count = %teamList.getSize() - %resourceCount;
   echo("you have "@%count);
   if(%count < 4)
   {
      echo("you dont have enough combat units");
      tsSendTaskPopUpDlg("ID_TASK_HopeRescue", "id_notenoughcombat", $TaskButton::More, "civ4", "id_notenoughcombat");   
   }
   else
   {
      TaskModifier.strMarkVertex("MainmapTasks", "LoadHRRescue", $TSV_AVAIL);   
   }
   tsDestroyObjList(%teamList);

}
function ResetHopeRescueAccept::onExit()
{
   TaskModifier.strResetVertex("MainmapTasks", "HopeRescueAccept");
   TaskModifier.strMarkVertex("MainmapTasks", "HopeRescueAccept", $TSV_AVAIL);
}

function ResetHopeRescueTask()
{
   TaskModifier.strResetVertex("MainmapTasks", "HopeRescueAccept");
   TaskModifier.strMarkVertex("MainmapTasks", "HopeRescueAccept", $TSV_AVAIL);
}
// Load HopeRiver Rescue map
function LoadHRRescue::onExit(%this)
{
   %scenario = new SLScenario()
   {
      stack = true;
      mapName = "assets/data/missions/sandlot/hoperiverrescue.mis";
      mapMinimap = "assets/client/ui/minimaps/hoperescueminimap.png";
      mapMain = false;
      
      resourceGold = "0 1";
      resourceWood = "0 1";
      resourceWater = "25 0";
      resourceFood = "25 0";
      resourceHappiness = "80 0";
     
      // Disaster fields
      addDisasterNode        = "0 100 0";
      disasterAnimalRate     = "0 0";
      disasterBanditRate     = "0 0";
      disasterDroughtRate    = "0 0";
      disasterEarthquakeRate = "0 0";
      disasterFamineRate     = "0 0";
      disasterFireRate       = "0 0";
      disasterPlagueRate     = "0 0";
      disasterTornadoRate    = "0 0";
      disasterStack = $DisasterStack::Push;
      
      // Units
      niceLawmen        = true;
      toughLawmen       = true;
      neutralLawmen     = true;
      niceGunslinger    = true;
      toughGunslinger   = true;
      neutralGunslinger = true;
      
   };
   LoadScenario(%scenario, deactivateMainMapTasks, StartCombatTasks, ResetHopeRescueTask);
}
// On Completing Hope Rescue Spawn the 3 civs from that map onto Mainmap move to roadsign.
function HopeRescueComplete::onExit(%this)
{
   // Spawn the 3 civs from Combat Rescue Map
   %char1obj = tsCreateObj("FemaleCiv", "HRciv1", $OST_PLAYER, "-463 -285", "HRciv1");
   tsSkinObj("HRciv1", "default");
   %char1obj.name = "Pamela Lindsay";
   
   %char2obj = tsCreateObj("FemaleCiv", "HRciv2", $OST_PLAYER, "-466 -285", "HRciv2");
   tsSkinObj("HRciv2", "default");
   %char2obj.name = "Emma Francis";
   
   %char3obj = tsCreateObj("MaleCiv", "HRciv3", $OST_PLAYER, "-466 -281", "HRciv3");
   tsSkinObj("HRciv3", "default");
   %char3obj.name = "Alexander Luther";
}
function HopeRescueReturnCiv::onExit()
{
   tsMoveObjToTarget("HRciv1", "-393 -291");
   tsMoveObjToTarget("HRciv2", "-392 -294");
   tsMoveObjToTarget("HRciv3", "-389 -292");
   tsSendTaskPopUpDlg("ID_Refugee", "ID_RefugeeReturn", $TaskButton::More, "HRciv3");
   tsSendTaskPopUpDlg("ID_Refugee", "ID_RefugeeEnd", $TaskButton::Okay, "civ4");
   tsSkinObj("HRciv1", "base");
   tsSkinObj("HRciv2", "base");
   tsSkinObj("HRciv3", "base");
   tsRemoveObj("civ4");
   TaskModifier.strMarkVertex("MainmapTasks", "BuildaBridgeReminder", $TSV_AVAIL);   
}

function StartCombatTasks()
{   
   InitializeQuestGui();
   slgActivateTask("CombatTask");
   TaskModifier.strMarkVertex("CombatTask", "StartCombat", $TSV_AVAIL);
}

////////////////////////////////////////////////////////////////////////////////
// Job Hunt
////////////////////////////////////////////////////////////////////////////////
$Jobhuntquest = "Job Hunt";
function JobhuntTrigger::onUpdate(%this)
{
   %resourceCount = rsGetResourceCount($Resource::People);
   if(%resourceCount >= 7)
   {  // Start job hunt task
      TaskModifier.StrMarkVertex("MainmapTasks", "JobhuntStart", $TSV_AVAIL);
      TaskModifier.StrMarkVertex("MainmapTasks", "JobhuntTrigger", $TSV_CMPLETE);
   }
}
// Function starts after a 30 second delay
function JobhuntStart::onExit(%this)
{
   // Create Joe Jack
   tsCreateObj("MaleCiv", "joejack", "0", "-330 -449", "joejack");
   tsSkinObj("joejack", "default");
   tsNameObj("joejack", "Joe-Jack Jebediah");
}
// Move character to zone
function JobhuntMove::onExit(%this)
{
   // Move Joe Jack 
   tsMoveObjToTarget("joejack", "-324 -401");   
}
// Joe Jack reaches woodzone
function JobhuntIntro::onExit(%this)
{   
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_Jobhunt", true, true, "ID_Jobhuntstart");
   tsAddTaskDialog("ID_Jobhuntstart", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "joejack");
   tsDestroyTaskDlgData(%dlgData);
}
// Accept Joe Jacks Task :ID_Jobhuntstart
function Jobhuntaccept::onExit(%this)
{  
   //Change teams
   tsConvertObjTeam("joejack", $OST_PLAYER);
   tsSkinObj("joejack", "base");
   
   tsSendTaskPopUpDlg("ID_TASKNAME_Jobhunt", "ID_Jobhuntaccept", $TaskButton::Okay, "joejack", "ID_Jobhuntaccept");
   TaskModifier.StrMarkVertex("MainmapTasks", "JobhuntEmployRanchSkip", $TSV_AVAIL);
   
   // Quest log
   tsAddQuestToTracker(false, "Job Hunt", "", "Find Joe-Jack Jebediah his dream job.", "Reward: Unknown");
   tsReadyQuest("Job Hunt");
   tsAddTaskToTracker("Job Hunt", "Find Joe-Jack his dream job.", "Figure out what Joe-Jack really wants to do with his life.");
   tsAddTaskToTracker("Job Hunt", "Employ Joe-Jack.", "Try employing Joe-Jack at a building.");
           
}
// Employ Joe at Ranch
function JobhuntEmployRanchSkip::onExit(%this)
{
  
   if(Jobhuntquit1delay.isComplete() == true)
   {
      tsCompleteTaskInTracker("Job Hunt", "Employ Joe-Jack again.");
   }
   if(Jobhuntquit2delay.isComplete() == true)
   {
      tsCompleteTaskInTracker("Job Hunt", "Employ Joe-Jack yet again.");
   }  
   TaskModifier.strMarkVertex("MainmapTasks", "JobhuntEmployRanch", $TSV_AVAIL);
   TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntquit1delay", $TSV_CLOSED);
   TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntquit2delay", $TSV_CLOSED);
   TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntfail", $TSV_CLOSED);  
}
// Employ Joe at any building. Timer delay 3 secs
function Jobhuntemploy1delay::onExit(%this)
{  
   %cmpChar = slgQueryInterface("joejack", $CID_CHARACTER);
   %workplace = %cmpChar.getWork();
   if(%workplace.getType() !$= "Ranch")
   {
      tsSendTaskPopUpDlg("ID_TASKNAME_Jobhunt", "ID_Jobhuntemployone", $TaskButton::Okay, "joejack", "ID_Jobhuntemployone");
   }
   else if(%workplace.getType() $= "Ranch")
   {
      // Close vertex. Enable end vertex.
      //TaskModifier.strMarkVertex("MainmapTasks", "JobhuntEmployRanchSkip", $TSV_CLOSED);
      TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntemploy1delay", $TSV_CLOSED);
      TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntemployranch", $TSV_AVAIL);
   }
   // Quest log
   tsCompleteTaskInTracker("Job Hunt", "Employ Joe-Jack.");
   
}
// If the 1st building is not a ranch quit job Timer delay 2 mins
function Jobhuntquit1delay::onExit(%this)
{  
   if(isObject("joejack"))
   {
      %charobj = joejack.getID();
      if(%charobj.isOnTeam($OST_PLAYER))
      {
         tsSendTaskPopUpDlg("ID_TASKNAME_Jobhunt", "ID_Jobhuntquitone", $TaskButton::Okay, "joejack");
         // Quit job
         
         slgUnemployObject(%charobj);
         // Quest log
         tsAddTaskToTracker("Job Hunt", "Employ Joe-Jack again.", "Try employing Joe-Jack at another building.");
      }
      
   }
}
// Employ Joe at any building. Timer delay 3 secs
function Jobhuntemploy2delay::onExit(%this)
{  
   %cmpChar = slgQueryInterface("joejack", $CID_CHARACTER);
   %workplace = %cmpChar.getWork();
   if(%workplace.getType() !$= "Ranch")
   {
      tsSendTaskPopUpDlg("ID_TASKNAME_Jobhunt", "ID_Jobhuntemploytwo", $TaskButton::Okay, "joejack", "ID_Jobhuntemploytwo");
   }
   else if(%workplace.getType() $= "Ranch")
   {
      // Close vertex. Enable end vertex.
      TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntemploy2delay", $TSV_CLOSED);
      TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntemployranch", $TSV_AVAIL);
   }
   // Quest log
   tsCompleteTaskInTracker("Job Hunt", "Employ Joe-Jack again.");
}
// If the 2nd building is not a ranch quit job Timer delay 2 mins
function Jobhuntquit2delay::onExit(%this)
{     
   if(isObject("joejack"))
   {  
      %charobj = joejack.getID();
      if(%charobj.isOnTeam($OST_PLAYER))
      {
         tsSendTaskPopUpDlg("ID_TASKNAME_Jobhunt", "ID_Jobhuntquittwo", $TaskButton::Okay, "joejack");
         // Quit job
         
         slgUnemployObject(%charobj);
         // Quest log
         tsAddTaskToTracker("Job Hunt", "Employ Joe-Jack yet again.", "Try employing Joe-Jack at yet another building. He sure is picky, isn't he?");
      }
      
   }
}
// Employ Joe at any building. Timer delay 3 secs
function Jobhuntemploy3delay::onExit(%this)
{  
   %cmpChar = slgQueryInterface("joejack", $CID_CHARACTER);
   %workplace = %cmpChar.getWork();
   if(%workplace.getType() !$= "Ranch")
   {
      tsSendTaskPopUpDlg("ID_TASKNAME_Jobhunt", "ID_Jobhuntemploythree", $TaskButton::Okay, "joejack", "ID_Jobhuntemploythree");
      TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntfail", $TSV_AVAIL);
   }
   else if(%workplace.getType() $= "Ranch")
   {
      // Close vertex. Enable end vertex.
      TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntemploy3delay", $TSV_CLOSED);
      TaskModifier.strMarkVertex("MainmapTasks", "Jobhuntemployranch", $TSV_AVAIL);
   }
   // Quest log
   tsCompleteTaskInTracker("Job Hunt", "Employ Joe-Jack yet again.");
}
// If the 3rd building is not a ranch quit job, end task
function Jobhuntfail::onExit(%this)
{     
   if(isObject("joejack"))
   {
      %charobj = joejack.getID();
      if(%charobj.isOnTeam($OST_PLAYER))
      {
         tsSendTaskPopUpDlg("ID_TASKNAME_Jobhunt", "ID_Jobhuntquitthree", $TaskButton::Okay, "joejack");
         // Quit job
         slgUnemployObject(%charobj);
         // Change teams back to neutral move joe jack off screen
         tsConvertObjTeam("joejack", 0);
         tsRemoveObj("joejack");
         
         // Quest log
         tsDisableQuest("Job Hunt");
      }      
   }
}
// Employ Joe at a Ranch
function Jobhuntemployranch::onExit(%this)
{  
   tsSendTaskPopUpDlg("ID_TASKNAME_Jobhunt", "ID_Jobhuntcomplete", $TaskButton::Okay, "joejack", "ID_Jobhuntcomplete");
   // Quest log
   //tsCompleteTaskInTracker("Job Hunt", "Employ Joe Jack.");
   tsCompleteTaskInTracker("Job Hunt", "Find Joe-Jack his dream job.");
   
}
// Gold Offer
function Jobhuntgold::onExit(%this)
{  
   tsSendTaskClickDlg("ID_TASK_Jobhuntgold", "ID_Jobhuntgold", $TaskButton::Accept, "joejack", "ID_Jobhuntgold");
}
// Gold Accept
function Jobhuntgoldaccept::onExit(%this)
{  
   //Close Outhouse offer
   tsDestroyTaskDlgIcon("ID_Jobhuntouthouse", "joejack");

   // Reward
   tsModifyResource($Resource::Experience, 10, true);
   tsModifyResource($Resource::Gold, 100, true);
   tsModifyResource($Resource::Wood, 100, true);
   SendProductionToClient(joejack, "10 experience");
   SendProductionToClient(joejack, "100 wood");
   SendProductionToClient(joejack, "100 gold");
}
// Outhouse Offer
function Jobhuntouthouse::onExit(%this)
{  
   tsSendTaskClickDlg("ID_TASK_JobhuntOuthouse", "ID_Jobhuntouthouse", $TaskButton::Accept, "joejack", "ID_Jobhuntouthouse");
}
// Outhouse Accept
function Jobhuntouthouseaccept::onExit(%this)
{  
   //Close Gold Offer
   tsDestroyTaskDlgIcon("ID_Jobhuntgold", "joejack");
   // Reward
   tsModifyResource($Resource::Experience, 10, true);
   SendProductionToClient(joejack, "10 experience");
   tsActivateBuildingXP("Outhouse"); // Unlock Outhouse 
}

////////////////////////////////////////////////////////////////////////////////
// Bad seed
////////////////////////////////////////////////////////////////////////////////
function BadSeedMapTrigger::onExit(%this)
{
   //TaskModifier.strMarkVertex("MainmapTasks", "DisastersMedTrigger", $TSV_AVAIL); 
}
// Vertex Completes player enters zone westside and 200 sec timer
function BadSeedMapStart::onExit(%this)
{   
   %charobj = tsCreateObj("FemaleCiv", "badseedgal", "0", "-59 -312", "badseedgal");
   tsSkinObj("badseedgal", "default");
   %charobj.name = "Sadey Malla";
}
// Vertex Completes on create of unit named badseedgal
function BadSeedonCreate::onExit(%this)
{   
   tsMoveObjToTarget("badseedgal", "centerroadsign");
   //Quest log
   tsAddQuestToTracker(true, "Bad Seed", "", "Someone is buying up all of the deeds to the town before they can be paid off.  Help Sadey Malla repay the bank before none of the town is left.", "Reward: Unknown");
   tsReadyQuest("Bad Seed");
   tsAddTaskToTracker("Bad Seed", "Help Sadey Malla and her town.", "Help Sadey Malla collect enough gold to pay off the bank.");
}
function BadSeedMapTaskAccept::onExit(%this)
{   
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_BADSEED", true, true, "id_badseedload");
   tsAddTaskDialog("id_badseedload", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "badseedgal");
   tsDestroyTaskDlgData(%dlgData);
}
function LoadBadSeed::onExit(%this)
{   
   %scenario = new SLScenario() {
      stack   = true;
      mapName = "assets/data/missions/sandlot/badseed.mis";
      mapMinimap = "assets/client/ui/minimaps/badseedminimap.png";
      mapMain = false;
      
      // Resources
      resourceGold       = "300 0";
      resourceWood       = "300 0";
      resourceFood       = "20 0";
      resourceFoodMax    = "20 0";
      resourceWater      = "6 0";
      resourceWaterMax   = "6 0";
      resourceHappiness  = "80 0";
      
      // Disaster fields
      addDisasterNode        = "0 180 1";
      disasterBanditRate     = "0 0";
      disasterDroughtRate    = "10 0";
      disasterEarthquakeRate = "0 0";
      disasterFamineRate     = "10 0";
      disasterFireRate       = "0 0";
      disasterPlagueRate     = "10 0";
      disasterTornadoRate    = "0 0";
      disasterStack = $DisasterStack::Push;
   };
   
   LoadScenario(%scenario, deactivateMainMapTasks, startBadSeedTasks, resetBadSeedTask);
}

////////////////////////////////////////////////////////////////////////////////
// Bridge Tutorial
////////////////////////////////////////////////////////////////////////////////
// Start Vertex on build lumbermill
function BridgetutTrigger::onExit(%this)
{
   // Start Bridge Tutorial
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_Bridgetut", true, false, "ID_BridgeTutorial");
   tsAddTaskDialog("ID_BridgeTutorial", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
}
function Bridgetutload::onExit(%this)
{
   // Create bridge tutorial scenario
   %scenario = new SLScenario()
   {
      stack   = true;
      mapMain = false;
      mapName = "assets/data/missions/sandlot/bridgetutorial.mis";
      mapMinimap = "assets/client/ui/minimaps/bridgetutminimap.png";
      
      // for all resources used for purchasing to zero
      resourceGold = "0 0";
      resourceWood = "0 0";
      resourceFood = "20 0";
      resourceFoodMax = "20";
      resourceWater = "0 0";
      resourceWaterMax = "0";
      resourceHappiness = "80 0";
      
      // Disaster fields
      addDisasterNode        = "0 100 0";
      disasterBanditRate     = "0 0";
      disasterDroughtRate    = "0 0";
      disasterEarthquakeRate = "0 0";
      disasterFamineRate     = "0 0";
      disasterFireRate       = "0 0";
      disasterPlagueRate     = "0 0";
      disasterTornadoRate    = "0 0";
      disasterStack = $DisasterStack::Push;
   };
   
   LoadScenario(%scenario, deactivateMainMapTasks, startBridgeTutorialTasks, "");
}

////////////////////////////////////////////////////////////////////////////////
// Gunslinger's warning
////////////////////////////////////////////////////////////////////////////////

// Slight delay after hope refugees come to town.
function BanditWarnIntro::onExit(%this)
{   
   //create gunslinger
   %gun1obj = tsCreateObj("femalegunslinger", "femalegun", "0", "-463 -278", "femalegun");
   %gun2obj = tsCreateObj("Malegunslinger", "malegun", "0", "-464 -280", "malegun");
   
   %gun1obj.name = "May East";
   %gun2obj.name = "Goonie Wiggins";
   
   tsSkinObj("malegun", "gunslingermale");
   tsSkinObj("femalegun", "gunslingerfemale");
   // Start timer for single bandit attack
   TaskModifier.strMarkVertex("MainmapTasks", "Lonebanditintro", $TSV_AVAIL);
}
function gunoncreate::onExit(%this)
{  
   // move gunslinger 
   tsMoveObjToTarget("malegun", "-387 -302");
   tsMoveObjToTarget("femalegun", "-388 -299");
   tsSendTaskClickDlg("ID_Task_Banditwarning", "id_gunslinger_intro", $TaskButton::More, "malegun", "id_gunslinger_intro");
}
function Gunslingerwarning::onExit(%this)
{   
   tsSendTaskPopUpDlg("ID_Task_Banditwarning", "id_gunslinger_warn", $TaskButton::Okay, "malegun", "id_gunslinger_warn");
}

function Gunslingeroffer::onExit(%this)
{      
   %dlgData = tsCreateTaskDlgData("ID_Task_Banditwarning", true, true, "id_gunslinger_offer" );
   tsAddTaskDialog("id_gunslinger_offer", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_SURE", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsAddAcceptCost($Resource::Gold, 50, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "malegun");
   tsDestroyTaskDlgData(%dlgData);
   
      
}

function Gunslingeraccept::onExit(%this)
{   
   tsConvertObjTeam("malegun", $OST_PLAYER);
   tsConvertObjTeam("femalegun", $OST_PLAYER); 
}

////////////////////////////////////////////////////////////////////////////////
// Lone Bandit Attack
////////////////////////////////////////////////////////////////////////////////

function Lonebanditintro::onExit(%this)
{   
   //create Bandit
   tsCreateObj("MaleBandit", "lonebandit", "2", "-464 -280", "lonebandit");
   tsNameObj("lonebandit", "Shifty Morgan");
   tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_loneattack", $TaskButton::Okay, "lonebandit", "id_loneattack");
}
function Lonebanditattack::onExit(%this)
{   
   //Get Goldmine ID
   %objList = tsCreateObjList();
   %goldminelist = slgGetServerBuildingList();
   %goldminelist.getTypeList("goldmine",%objList);
   %count=0;
   for(%index = 0; %index < %objList.getSize(); %index++)
   {
      %object = %objList.getID(%index);
      if(%object.getTeam() == "1")
      { 
         %count++;
      }
   }
   tsDestroyObjList(%objList);
   if(%count == 0)
   {
      //Goldmine does not exist, move to guard goldvein
      tsMoveObjToTarget("lonebandit", "-349 -401");
   }
   else
   {
     //Attack Goldmine
      tsStartBanditAttack("lonebandit", %object); 
   }
}

function Lonebanditdefeat::onExit(%this)
{   
   tsSendTaskPopUpDlg("ID_Task_Banditwarning", "id_lonedefeat", $TaskButton::Okay, "heroCharacter", "id_lonedefeat");
   
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience");
   
   // Start Boom Town
   TaskModifier.strMarkVertex("MainmapTasks", "BoomTownStart", $TSV_AVAIL);
   // Start Dual Bandit Attack
   TaskModifier.strMarkVertex("MainmapTasks", "Dualbanditintro", $TSV_AVAIL);
   TaskModifier.strMarkVertex("MainmapTasks", "DualbanditNeedSheriff", $TSV_AVAIL);
   // Turn on Low Disasters
   
}

////////////////////////////////////////////////////////////
// Dual Bandit Attack 
////////////////////////////////////////////////////////////

// Vertex Starts after LoneBandit Defeat and 190 secs
function Dualbanditintro::onExit(%this)
{   
   //create 2 Bandits
   // Check for Sheriffs Office
   %objList = tsCreateObjList();
   %SOfficelist = slgGetServerBuildingList();
   %SOfficelist.getTypeList("sheriffsoffice",%objList);
   %SOcount=0;
   for(%index = 0; %index < %objList.getSize(); %index++)
   {
      %SOobject = %objList.getID(%index);
      if(%SOobject.getTeam() == "1")
      {
         %SOcount++;
      }
   } 
   tsDestroyObjList(%objList);
   // Check to see if a Sheriffs Office exists if not attack mine.   
   if(%SOcount == 0)
   {
      %bandit1obj = tsCreateObj("MaleBandit", "", "2", "-461 -280", "dualbandit1");
      %bandit2obj = tsCreateObj("FemaleBandit", "", "2", "-464 -284", "dualbandit2");
      %bandit1obj.Setname("dualbandit1");
      %bandit2obj.Setname("dualbandit2");
      %dialogname = %bandit1obj.name; 
      
      %deadbanditobj = tsCreateObj("MaleBandit", "deadbandit", "0", "0 0", "deadbandit");
      %deadbanditobj.name = %dialogname;
   }
   else
   {
      TaskModifier.strMarkVertex("MainmapTasks", "Dualbanditsheriff", $TSV_AVAIL);
      TaskModifier.strMarkVertex("MainmapTasks", "Dualbanditintro", $TSV_CLOSED);
   }
}
// Vertex Starts on create of dualbandits
function DualBanditmove::onExit(%this)
{  
   //Get Goldmine ID
   %objList = tsCreateObjList();
   %goldminelist = slgGetServerBuildingList();
   %goldminelist.getTypeList("goldmine",%objList);
   %count=0;
   for(%index = 0; %index < %objList.getSize(); %index++)
   {
      %object = %objList.getID(%index);
      if(%object.getTeam() == "1")
      {
         %count++;
      }
   } 
   tsDestroyObjList(%objList);
      
   //Get Random town civ
   %team = tsCreateObjList();
   %list = slgGetServerCharacterList();
   %list.getTeamList($OST_PLAYER, %team);
   %civobj = %team.getRandomObject();
   tsDestroyObjList(%team);

   if(%count == 0)
   {
      //Goldmine does not exist, move to guard goldvein
      tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_Dualwarninggold", $TaskButton::Okay, %civobj);
      tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_Dualattack", $TaskButton::Okay, "dualbandit1");
      tsMoveObjToTarget("dualbandit1", "-349 -399");
      tsMoveObjToTarget("dualbandit2", "-348 -398");
   }
   else
   {
      //Attack Goldmine      
      tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_Dualwarninggoldmine", $TaskButton::Okay, %civobj);
      tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_Dualattack", $TaskButton::Okay, "dualbandit1");
      tsStartBanditAttack("dualbandit1", %object);
      tsStartBanditAttack("dualbandit2", %object);  
   }
}
function dualbanditdefeat::onExit(%this)
{   
   tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_dualdefeat", $TaskButton::Okay, "deadbandit", "id_dualdefeat");
   
   // Check if sheriffsOffice is built during attack
   if(BoomtownComplete.isMarkedComplete())
   {
      TaskModifier.strMarkVertex("MainmapTasks", "Dualbanditsheriff", $TSV_AVAIL);
   }
   else
   {
      %timer = new SLTimer()
      {
         time = 0;
      };
      %timer.notifyOnFire(DualAttackReset, %timer);
   }
}

function SLTimer::DualAttackReset(%timer)
{
   TaskModifier.strResetVertex("MainmapTasks", "Dualbanditintro");
   TaskModifier.strMarkVertex("MainmapTasks", "Dualbanditintro", $TSV_AVAIL);
}
function dualdefeatdialog::onExit(%this)
{
   // removes Bandit defeat dialog portrait character
   deadbandit.deleteObject();   
}
function DualbanditNeedSheriff::onExit(%this)
{
   tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_dualNeedSheriff", $TaskButton::Okay, "herocharacter");
}
////////////////////////////////////////////////////////////
// Sheriff Bandit Attack
////////////////////////////////////////////////////////////
// Vertex Completes on timer 200 secs after sheriff is hired
function Dualbanditsheriff::onExit(%this)
{   
   //create 2 Bandits
   tsCreateObj("MaleBandit", "sheriffbandit", "2", "-461 -280", "sheriffbandit");
   tsCreateObj("FemaleBandit", "sheriffbandit2", "2", "-464 -284", "sheriffbandit2");
   tsNameObj("sheriffbandit", "Bobby McClane");
   tsNameObj("sheriffbandit2", "Bobbi McClane");   
}
function SheriffBanditmove::onExit(%this)
{  
   //Get SheriffsOffice ID
   %objList = tsCreateObjList();
   %SOlist = slgGetServerBuildingList();
   %SOlist.getTypeList("sheriffsoffice",%objList);
   // Check for SheriffsOffice 
   if(%objList.getSize() > 0)
   {
      %object = %objList.getID(0);
      tsStartBanditAttack("sheriffbandit", %object);
      tsStartBanditAttack("sheriffbandit2", %object);
      tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_Dualsheriffattack", $TaskButton::Okay, "sheriffbandit");
   }
   else
   {
      tsMoveObjToTarget("sheriffbandit", "-349 -399");
      tsMoveObjToTarget("sheriffbandit2", "-348 -398");
      tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_Dualnosheriff", $TaskButton::Okay, "sheriffbandit");
   }
   tsDestroyObjList(%objList);
}
function Sheriffbanditdefeat::onExit(%this)
{
   tsSendTaskPopUpDlg("ID_Task_DualBanditAttack", "id_Dualsheriffdefeat", $TaskButton::Okay, "herocharacter");
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience");
   
}

//***************************************************
//* Alternate route to unlock sheriffs office
//***************************************************

function dualbanditchallenge::onExit(%this)
{
   if(!(BoomtownUnlock.isMarkedComplete()))
   {
      TaskModifier.strMarkVertex("MainmapTasks", "dualbanditcreatedeputy", $TSV_AVAIL);
   }
}
function dualbanditcreatedeputy::onExit(%this)
{
   //Create Free Deputy to Unlock SheriffsOffice
   %obj = tsCreateObj("deputy","freedeputy", "0", "-463 -278", "freedeputy");
   %obj.name = "Timmy Jones";
}
function DualBanditDeputy::onExit(%this)
{  
   // move deputy
   tsMoveObjToTarget("freedeputy", "-389 -300");
   tsSendTaskClickDlg("ID_TASK_Boomtown", "id_freedeputy", $TaskButton::Okay, "freedeputy", "id_freedeputy");
}
function DualBanditFreeOffice::onExit(%this)
{      
   %dlgData = tsCreateTaskDlgData("ID_TASK_Boomtown", true, true, "id_freesheriffsOffice" );
   tsAddTaskDialog("id_freesheriffsOffice", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_SURE", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsAddAcceptCost($Resource::Gold, 120, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "freedeputy");
   tsDestroyTaskDlgData(%dlgData);   
}
// Unlock Sheriffs Office Store, and convert deputy to player
function FreeOfficeAccept::onExit(%this)
{  
   tsConvertObjTeam("freedeputy", "1");   
   SendProductionToClient(freedeputy, "-120 gold");
   tsActivateBuildingXP("SheriffsOffice");
   // Complete Unlock Vertex
   if(!(BoomtownUnlock.isMarkedComplete())){
      TaskModifier.strMarkVertex("MainmapTasks", "BoomtownUnlock", $TSV_CMPLETE);
   }
}
  
////////////////////////////////////////////////////////////
// Dead Mine Trigger on Main map
////////////////////////////////////////////////////////////
// Vertex completes after Bridge tutorial Trigger
function MainmapDeadmineTrigger::onExit(%this)
{   
   //Reduce gold production
   SetBuildingGoldRate(0.5);
   
   // Find random civ
   tsSendTaskPopUpDlg("ID_Task_Deadmine", "id_deadminegoldloss", $TaskButton::More, "herocharacter", "id_deadminegoldloss");
   tsSendTaskPopUpDlg("ID_Task_Deadmine", "id_deadminecamp", $TaskButton::Okay, "herocharacter", "id_deadminecamp");
   // Spawn Cave
   tsCreateObj("cave", "DMcave", "-1", "-401 -148", "DMcave");
   
   //Quest log
   tsAddQuestToTracker(true, "Dead Mine", "", "Find out what's cutting into your Gold Mine's production.", "Reward: Unknown");
   tsReadyQuest("Dead Mine");
   tsAddTaskToTracker("Dead Mine", "Investigate the mining camp across the river.", "They're up to something at the mining camp across the river. See what it is.");
}
// Player enters zone: banditdigsite 
function MainmapDMbanditdigsite::onExit(%this)
{
   Parent::onExit(%this);
   
   // Get id of character that triggered zone
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %count = 0;
   for(%index = 0; %index < %teamList.getSize(); %index++)
   {
      %charID = %teamList.getID(%index);
      if(%charID.isInZone(banditdigsite))
      {
         %count++;
         break;
      }
   }
   if(%count == 0){
      %charID = "herocharacter";
   }
   tsDestroyObjList(%teamList);
   
   tsSendTaskPopUpDlg("ID_Task_Deadmine", "id_DMmapzonetrigger", $TaskButton::More, "DMgun1");
   tsSendTaskPopUpDlg("ID_Task_Deadmine", "id_DMmapzoneask", $TaskButton::More, %charID);
   tsSendTaskPopUpDlg("ID_Task_Deadmine", "id_DMmapzonepanic", $TaskButton::More, "DMgun2");
   tsSendTaskPopUpDlg("ID_Task_Deadmine", "id_DMmapzoneattack", $TaskButton::Okay, "DMgun1", "id_DMmapzoneattack");
      
   // Change teams of DMguns
   tsConvertObjTeam("DMgun1", "2");
   tsConvertObjTeam("DMgun2", "2");
   // remove worker and spawn gunslinger in place

   DMworker.deleteObject();
   tsCreateObj("Malebandit", "DMgun3", "2", "-391 -146", "DMgun3");
   tsNameObj("DMgun3", "Vic Virgil");
   // Quest log
   tsAddTaskToTracker("Dead Mine", "Defeat crooked Miners.", "Defeat crooked Miners.");
   
   // Complete vertex
   TaskModifier.strMarkVertex("MainmapTasks", "MainmapDMbanditdigsite", $TSV_CMPLETE);
}
// Defeat Bandit Gunslingers 
function MainmapDMbanditdelay::onExit(%this)
{   
   tsSendTaskPopUpDlg("ID_Task_Deadmine", "id_DMmapgundefeat", $TaskButton::Okay, "herocharacter");
   // Quest log
   tsCompleteTaskInTracker("Dead Mine", "Defeat crooked Miners.");
}
// Player enters zone: deadminezone
function MainmapDeadminezone::onExit(%this)
{
   Parent::onExit(%this);
   
   // Get id of character that triggered zone
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %count = 0;
   for(%index = 0; %index < %teamList.getSize(); %index++)
   {
      %charID = %teamList.getID(%index);
      if(%charID.isInZone(deadminezone))
      {
         %count++;
         break;
      }
   }
   if(%count == 0){
      %charID = "herocharacter";
   }
   tsDestroyObjList(%teamList);
   
   tsSendTaskPopUpDlg("ID_Task_Deadmine", "id_DMmapcave", $TaskButton::Okay, %charID, "id_DMmapcave");
   
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(%charID, "5 experience");

}
function MainmapDeadmineAccept::onExit(%this)
{   
   %charobj = tsCreateObj("Malebandit", "cavebubble", "0", "-399 -147", "cavebubble");
   tsShowMesh("cavebubble", false);
   %charobj.name = "Cave ";
}
function MainDeadmineResetDelay::onExit(%this)
{   
   
   if(firstword(getRes()) > 800)
   {
      %image1Pos = "33 69";
   }
   else
   {
      %image1Pos = "25 54";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/hud/cave_portrait.png"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "93 88";
      position = %image1Pos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_Task_Deadmine", true, true, "id_DMmapaccept");
   tsAddTaskDialog("id_DMmapaccept", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "cavebubble");
   tsDestroyTaskDlgData(%dlgData);
}
// Loads Deadmine Satellite map
function LoadDeadmine::onExit(%this)
{   
     Parent::onExit(%this);
   
   %scenario = new SLScenario() {
      stack   = true;
      mapName = "assets/data/missions/sandlot/deadmine.mis";
      mapMinimap = "assets/client/ui/minimaps/deadmineminimap.png";
      mapMain = false;
      
      // Resources
      resourceGold       = "0 1";
      resourceWood       = "0 1";
      resourceFood       = "20 0";
      resourceFoodMax    = "20 0";
      resourceWater      = "0 0";
      resourceWaterMax   = "0 0";
      resourceHappiness  = "80 0";
      
      // Units
      niceLawmen        = true;
      toughLawmen       = true;
      neutralLawmen     = true;
      niceGunslinger    = true;
      toughGunslinger   = true;
      neutralGunslinger = true;
      
      // Disaster fields
      addDisasterNode        = "0 100 0";
      disasterBanditRate     = "0 0";
      disasterDroughtRate    = "0 0";
      disasterEarthquakeRate = "0 0";
      disasterFamineRate     = "0 0";
      disasterFireRate       = "0 0";
      disasterPlagueRate     = "0 0";
      disasterTornadoRate    = "0 0";
      disasterStack = $DisasterStack::Push;
   };
   
   LoadScenario(%scenario, deactivateMainMapTasks, startDeadMineTasks, resetDeadMineTasks); 
}

////////////////////////////////////////////////////////////
// Boom Town Intro 
////////////////////////////////////////////////////////////
$BuildingCnt = 15;
$BoomtownQuest = "Keeping the Peace";
// Starts after Lone Bandit is defeated short delay 2 secs
function BoomTownStart::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASK_Boomtown", false, $TaskButton::More, "ID_BoomtownIntro");
   tsAddTaskDialog("ID_BoomtownIntro", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Anistacia");
   tsDestroyTaskDlgData(%dlgData);
   
   %dlgData = tsCreateTaskDlgData("ID_TASK_Boomtown", false, false, "ID_BoomtownTask");
   tsAddTaskDialog("ID_BoomtownTask", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "HeroCharacter");
   tsDestroyTaskDlgData(%dlgData);
   
   XPBuySheriffsOffice.hideReq1 = false; 
   
   // Quest log
   tsAddQuestToTracker(true, $BoomtownQuest, "", "Build a Sheriff's Office to hire some Lawmen.", "Reward: 15 Experience.");
   tsReadyQuest($BoomtownQuest);
   tsAddTaskToTracker($BoomtownQuest, "Build a Sheriff's Office.", "Build a Sheriff's Office to hire some Lawmen.");
}

function BoomtownIntro::onExit(%this)
{
   %list =  slgGetServerBuildingList();
   %count = 0; 
   for(%index = 0; %index < %list.getSize(); %index++)
   {
      %object = %list.getID(%index);
      if(%object.isOnTeam($OST_PLAYER) && %object.isTownBuilding() == true)
      {
         %cmpBldg = slgQueryInterface(%object, $CID_BUILDING);
         if( %cmpBldg.getState() == $BuildingState::Production)
         {
            %count++;
         }
      }
   }
   if(%count >= $BuildingCnt)
   {
      TaskModifier.strMarkVertex("MainmapTasks", "BoomtownUnlock", $TSV_AVAIL);
      TaskModifier.strMarkVertex("MainmapTasks", "BoomtownSheriffOfficeUnlock", $TSV_AVAIL);
      XPBuySheriffsOffice.reqCheck1 = true;
      TaskModifier.strMarkVertex("MainmapTasks", "dualbanditchallenge", $TSV_AVAIL);
      //Quest log
      tsAddTaskToTracker($BoomtownQuest, "Unlock the Sheriff's Office.", "Build a Sheriff's Office to hire some Lawmen.");
      //Reward
      tsModifyResource($Resource::Experience, 15, true);
      SendProductionToClient(HeroCharacter, "15 experience"); 
            
   }
   else if(%count < $BuildingCnt)
   {      
      //Quest log
      %buildnum = "You have "@%count@" out of "@$BuildingCnt@" buildings needed.";
      tsReplaceTaskInTracker($BoomtownQuest,%buildnum, %buildnum, "Build up the size of your town to "@$BuildingCnt@" buildings.");
      TaskModifier.strMarkVertex("MainmapTasks", "Boomtownbuild", $TSV_AVAIL);
      TaskModifier.strMarkVertex("MainmapTasks", "Boomtowndestroy", $TSV_AVAIL);        
   }
}
function Boomtownbuild::onMessage(%vertex, %type, %param)
{
   // check if a building is built
   Parent::onMessage(%vertex, %type, %param);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }
   
   %list =  slgGetServerBuildingList();
   %count = 0; 
   for(%index = 0; %index < %list.getSize(); %index++)
   {
      %object = %list.getID(%index);
      if(%object.isOnTeam($OST_PLAYER) && %object.isTownBuilding() == true)
      {
         %cmpBldg = slgQueryInterface(%object, $CID_BUILDING);
         if( %cmpBldg.getState() == $BuildingState::Production)
         {
            %count++;
         }
      }
   }
   if(%count >= $BuildingCnt)
   {
      TaskModifier.strMarkVertex("MainmapTasks", "BoomtownUnlock", $TSV_AVAIL);
      TaskModifier.strMarkVertex("MainmapTasks", "BoomtownSheriffOfficeUnlock", $TSV_AVAIL);
      TaskModifier.strMarkVertex("MainmapTasks", "Boomtowndestroy", $TSV_CLOSED);
      XPBuySheriffsOffice.reqCheck1 = true;
      TaskModifier.strMarkVertex("MainmapTasks", "dualbanditchallenge", $TSV_AVAIL);
      
      //Quest log
      
      %buildnum = "You have "@$BuildingCnt@" out of "@$BuildingCnt@" buildings needed.";
      %buildpast = GetQuestTaskBrief($BoomtownQuest, "Build up the size of your town to "@$BuildingCnt@" buildings.", 0);
      //%buildpast = "You have "@%count-1@" out of "@$BuildingCnt@" buildings needed.";
      tsReplaceTaskInTracker($BoomtownQuest,%buildpast,%buildnum,"Build up the size of your town to "@$BuildingCnt@" buildings.");
      boomtownquestcheck();
      //Reward
      tsModifyResource($Resource::Experience, 15, true);
      SendProductionToClient(HeroCharacter, "15 experience");      
   }
   else
   {
      
      %buildnum = "You have "@%count@" out of "@$BuildingCnt@" buildings needed.";
      %buildpast = GetQuestTaskBrief($BoomtownQuest, "Build up the size of your town to "@$BuildingCnt@" buildings.", 0);
      //%buildpast = "You have "@%count-1@" out of "@$BuildingCnt@" buildings needed.";
      tsReplaceTaskInTracker($BoomtownQuest,%buildpast,%buildnum,"Build up the size of your town to "@$BuildingCnt@" buildings.");
      
      // Reset task if count is less than 15
      %vertex.decCompleteCount();
      TaskModifier.strMarkVertex("MainmapTasks", "Boomtownbuild", $TSV_AVAIL);
   }
}

function boomtownquestcheck()
{
   //Quest log
   tsAddTaskToTracker($BoomtownQuest, "Unlock the Sheriff's Office.", "Build a Sheriff's Office to hire some Lawmen.");
   tsCompleteTaskInTracker($BoomtownQuest, "You have "@$BuildingCnt@" out of "@$BuildingCnt@" buildings needed.");    
}
// Check for destroyed buildings
function Boomtowndestroy::onMessage(%vertex, %type, %param)
{
   // check if a building is destroyed
   Parent::onMessage(%vertex, %type, %param);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }
   
   %list =  slgGetServerBuildingList();
   %count = 0;
   for(%index = 0; %index < %list.getSize(); %index++)
   {
      %object = %list.getID(%index);
      if(%object.isOnTeam($OST_PLAYER) && %object.isTownBuilding() == true)
      {
         %cmpBldg = slgQueryInterface(%object, $CID_BUILDING);
         if( %cmpBldg.getState() == $BuildingState::Production)
         {
            %count++;
         }
      }
   }

   %buildnum = "You have "@%count@" out of "@$BuildingCnt@" buildings needed.";
   %buildpast = GetQuestTaskBrief($BoomtownQuest, "Build up the size of your town to "@$BuildingCnt@" buildings.", 0);
   //%buildpast = "You have "@%count+1@" out of "@$BuildingCnt@" buildings needed.";
   tsReplaceTaskInTracker($BoomtownQuest,%buildpast,%buildnum,"Build up the size of your town to "@$BuildingCnt@" buildings.");
   
   // Reset task if count is less than $BuildingCnt
   %vertex.decCompleteCount();
   TaskModifier.strMarkVertex("MainmapTasks", "Boomtowndestroy", $TSV_AVAIL);          
}

function BoomtownUnlock::onExit(%this)
{
   //Quest log
   tsCompleteTaskInTracker($BoomtownQuest, "Unlock the Sheriff's Office.");
}
// 
function BoomtownComplete::onExit(%this)
{
   //Quest log
   tsCompleteTaskInTracker($BoomtownQuest, "Build a Sheriff's Office.");
         
   // Start Bridge Defense Trigger Task Stranded
   TaskModifier.strMarkVertex("MainmapTasks", "strandeddelay", $TSV_AVAIL);
   
   // Hire Sheriff Vertices
   TaskModifier.strMarkVertex("MainmapTasks", "NiceSheriffHire", $TSV_AVAIL);
   TaskModifier.strMarkVertex("MainmapTasks", "ToughSheriffHire", $TSV_AVAIL);
   TaskModifier.strMarkVertex("MainmapTasks", "DisasterslowTrigger", $TSV_AVAIL);  
}
function BoomtownSheriffOfficeUnlock::onExit(%this)
{
   // Dialog telling you to unlock the Sheriff's Office
   tsSendTaskPopUpDlg("ID_TASK_Boomtown", "ID_BoomtownOfficeUnlock", $TaskButton::Okay, "herocharacter");
}
function ToughSheriffHire::onExit(%this)
{
   // Change to get sheriff id
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("Toughsheriff", "char", %objList);
   if(%objList.getSize() > 0)
   {
      %char = %objList.getID(0);
   }
   else
   {
      %char = "herocharacter";
   }
   tsDestroyObjList(%objList);
   TaskModifier.strMarkVertex("MainmapTasks", "NiceSheriffHire", $TSV_CLOSED);
   tsSendTaskPopUpDlg("ID_TASK_Boomtown", "ID_ToughSheriffHire", $TaskButton::Okay, %char);
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience");
}
function NiceSheriffHire::onExit(%this)
{
   // Change to get sheriff id
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("Nicesheriff", "char", %objList);
   if(%objList.getSize() > 0)
   {
      %char = %objList.getID(0);
   }
   else
   {
      %char = "herocharacter";
   }
   tsDestroyObjList(%objList);
   TaskModifier.strMarkVertex("MainmapTasks", "ToughSheriffHire", $TSV_CLOSED);
   tsSendTaskPopUpDlg("ID_TASK_Boomtown", "ID_NiceSheriffHire", $TaskButton::Okay, %char);
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience");
}

////////////////////////////////////////////////////////////////////////////////
// Disasters Low
////////////////////////////////////////////////////////////////////////////////

//Turn on Disasters 
function DisasterslowTrigger::onEnter(%this)
{   
   TaskModifier.strMarkVertex("MainmapTasks", "DisasterslowTrigger", $TSV_CMPLETE);

   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 3 minutes, a disaster can occur
      addDisasterNode = "0 180 1";
      
      // frequency pool, respawning time
      disasterBanditRate = "10 200";
      disasterDroughtRate = "10 120";
      disasterEarthquakeRate = "10 180";
      disasterFamineRate = "10 120";
      disasterFireRate = "0 200";
      disasterPlagueRate = "10 120";
      disasterTornadoRate = "10 200";
      disasterStack = $DisasterStack::Push;
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 10;
      duration = 1000;

      fadeTime = 1;
      goldMin = 0;
      goldMax = 100;
      goldLow = 5;
      goldHigh = 10;
      lowCount = 1;
      highCount = 2;

      happinessCount = -25;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 10;
      addRequirement = well;
      duration = 45;
      
      cost = 0.5;
   };
   
   // update the earthquake scenario
   %scenario.disasterEarthquakeScenario = new SLEarthquakeScenario()
   {
      chance = 14;
      duration = 5;
      
      shakeDistance = 0.4;
      damageLow = 20;
      damageHigh = 30;
   };
   
   // update the famine scenario
   %scenario.disasterFamineScenario = new SLFamineScenario()
   {
      chance = 15;
      //addRequirement = Granary;
      duration = 0;
      
      resource = $Resource::Food;
      cost = 0.50;
   };
      
   // update the plague scenario
   %scenario.disasterPlagueScenario = new SLPlagueScenario()
   {
      chance = 20;
      addRequirement = Farm;
      addRequirement = Ranch;
      duration = 30;
      
      produceRate = 0.5;
      addProduce = "wheat";
      addProduce = "corn";
      addProduce = "pumpkin";
      addProduce = "chicken";
      addProduce = "pig";
      addProduce = "cow";
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 15;
      duration = 50;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 25;
   };
   
   LoadScenario(%scenario);
}
// Vertex completes 10 mins after low disasters
function DisasterFireDialog::onExit(%this)
{
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("Maleciv", "char", %objList);
   %count=0;
   for(%index = 0; %index < %objList.getSize(); %index++)
   {
      %object = %objList.getID(%index);
      if(%object.getTeam() == "1")
      {
         %charobj = %objList.getID(%index);
         %count++;
      }
   }
   if(%count < 1)
   {
      %charobj = "herocharacter";
   }
   tsDestroyObjList(%objList);
      
   tsSendTaskPopUpDlg("ID_TASKNAME_FIRETUT", "id_firedisaster", $TaskButton::Okay, %charobj, "id_firedisaster");
   
}
function LoadFireTutorial::onExit(%this)
{
   Parent::onExit(%this);
   
   // Create fire tutorial scenario
   %scenario = new SLScenario() {
      stack   = true;
      mapName = "assets/data/missions/sandlot/firetutorial.mis";
      mapMinimap = "assets/client/ui/minimaps/firetutminimap.png";
      mapMain = false;
      
       // Resources
      resourceGold       = "0 0";
      resourceWood       = "0 0";
      resourceFood       = "15 0";
      resourceFoodMax    = "20 0";
      resourceWater      = "0 0";
      resourceWaterMax   = "0 0";
      resourceHappiness  = "80 0";
      //resourcePeople = 5;
      
      addDisasterNode = "0 30 1";
      
      // Disaster fields
      disasterAnimalRate     = "0 0";
      disasterBanditRate     = "0 0";
      disasterDroughtRate    = "0 0";
      disasterEarthquakeRate = "0 0";
      disasterFamineRate     = "0 0";
      disasterFireRate       = "0 0";
      disasterPlagueRate     = "0 0";
      disasterTornadoRate    = "0 0";
      
      disasterStack = $DisasterStack::Push;
   };
   
   LoadScenario(%scenario, deactivateMainMapTasks, startFireTutorialTasks, quitFireTutorialTasks);
}
////////////////////////////////////////////////////////////////////////////////
// Disasters Med
////////////////////////////////////////////////////////////////////////////////

function DisastersMedTrigger::onExit(%this)
{   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 2 minutes, a disaster can occur
      addDisasterNode = "0 120 1";
      
      // frequency pool, respawning time
      disasterBanditRate = "10 160";
      disasterDroughtRate = "10 120";
      disasterEarthquakeRate = "10 180";
      disasterFamineRate = "10 120";
      disasterFireRate = "10 180";
      disasterPlagueRate = "10 120";
      disasterTornadoRate = "10 180";

      disasterStack = $DisasterStack::Push;
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 15;
      duration = 1000;

      fadeTime = 1;
      goldMin = 50;
      goldMax = 200;
      goldLow = 5;
      goldHigh = 10;
      lowCount = 1;
      highCount = 2;

      happinessCount = -20;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 15;
      addRequirement = well;
      duration = 45;
      
      cost = 0.95;
   };
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 15;
      duration = -1;
      
      startStrength = 1;
      
      spreadCount = 2;
      spreadTime = 15;
      spreadChance = 30;
      spreadRadius = 25;
      spreadStrength = 1;
      
      burnTime = 14;
      burnStrength = 1;
      burnMax = 4;
            
      damageTime = 0.5;
      damageStrength = 1;
   };
   // update the earthquake scenario
   %scenario.disasterEarthquakeScenario = new SLEarthquakeScenario()
   {
      chance = 15;
      duration = 5;
      
      shakeDistance = 0.4;
      damageLow = 20;
      damageHigh = 35;
   };
   
   // update the famine scenario
   %scenario.disasterFamineScenario = new SLFamineScenario()
   {
      chance = 15;
      //addRequirement = Granary;
      duration = 0;
      
      resource = $Resource::Food;
      cost = 0.50;
   };
      
   // update the plague scenario
   %scenario.disasterPlagueScenario = new SLPlagueScenario()
   {
      chance = 15;
      addRequirement = Farm;
      addRequirement = Ranch;
      duration = 30;
      
      produceRate = 0.5;
      addProduce = "wheat";
      addProduce = "corn";
      addProduce = "pumpkin";
      addProduce = "chicken";
      addProduce = "pig";
      addProduce = "cow";
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 15;
      duration = 50;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 25;
   };
   
   LoadScenario(%scenario);
}
////////////////////////////////////////////////////////////////////////////////
// Food Low
// Responsible for monitoring food and, when it reaches zero, starts a timer for
// player notification of low food. Notification happens once only
////////////////////////////////////////////////////////////////////////////////
function FoodLowTrigger::onUpdate(%this)
{
   // Swap to timer for notification
   %foodCnt = rsGetResourceCount($Resource::Food);
   if(%foodCnt <= 0) {
      tsCompleteVertexes("MainmapTasks", "FoodLowTrigger");
   }
}
function FoodLowTimer::onUpdate(%this)
{
   // Swap back to trigger state
   %foodCnt = rsGetResourceCount($Resource::Food);
   if(%foodCnt > 0) {
      tsActivateVertexes("MainmapTasks", "FoodLowTrigger");
   }
}
function FoodLowTimer::onExit(%this)
{
   // Send notification about low food
   tsSendTaskPopUpDlg("ID_TASKNAME_LowFood", "id_warnfoodlow", $TaskButton::Okay, "HeroCharacter");
}

////////////////////////////////////////////////////////////////////////////////
// Stranded Task leading up to Bridge Defense
////////////////////////////////////////////////////////////////////////////////
// Vertex starts after boomtown is completed with 30 sec delay
function StrandedDelay::onExit()
{   
  //Spawn Riverdude town civ. move to destroyed bridge
   %charobj = tsCreateObj("MaleCiv", "riverdude", "0", "-200 -295", "riverdude");
   %charobj.name = "Jack Cooper";
   tsSkinObj("riverdude", "default");   
}
// Vertex Completes 3 secs after StrandedDelay
function Strandedhelp::onExit()
{   
   tsMoveObjToTarget("riverdude", "-232 -295");
   tsSendTaskClickDlg("ID_TASK_Stranded", "id_strandedhelp", $TaskButton::Okay, "riverdude", "id_strandedhelp");
}
// Vertex Completes after dialog id_strandedhelp
function StrandedRoadsign::onExit()
{   
   tsSendTaskPopUpDlg("ID_TASK_Stranded", "id_strandedwait", $TaskButton::Okay, "riverdude", "id_strandedwait");
   tsMoveObjToTarget("riverdude", "westroadsign");
   // Quest log
   tsAddQuestToTracker(true, "Cross the River", "", "Make your way across the river to talk to Jack Cooper whose town had its Bridges destroyed. Building a Lumber Mill will allow you to build bridges so you can cross the river.", "Reward: Gold and 20 Experience");
   tsReadyQuest("Cross the River");
   tsAddTaskToTracker("Cross the River", "Talk to Jack Cooper.", "Cross the river to the west and talk to the Citizen waiting at the Road Sign.");
}
// Vertex Completes player enters bridgedefensezone
function BridgeDefenseReset::onExit()
{   
   // Quest log
   tsAddTaskToTracker("Cross the River", "Help Jack Cooper.", "Go to Jack Cooper's Town and fight off the bandit attacks so they can rebuild their bridges.");   
   tsCompleteTaskInTracker("Cross the River", "Talk to Jack Cooper.");
      
   tsSendTaskClickDlg("ID_TASK_Stranded", "id_strandedready", $TaskButton::Accept, "riverdude", "id_strandedready");
   
   // Start Dead Mine Trigger
   TaskModifier.strMarkVertex("MainmapTasks", "MainmapDeadmineTrigger", $TSV_AVAIL);
}

function BuildaBridgeReminder::onExit(%this)
{
   //Check to make sure Jack Cooper's task has been started and they have not yet built a lumber mill   
   if(StrandedRoadsign.isMarkedComplete() == true)
   {
      if(BridgetutTrigger.isMarkedComplete() == false)
      {    
         tsSendTaskPopUpDlg("ID_TASK_Stranded", "ID_BuildBridgeReminder", $TaskButton::More, "riverdude");
      }
   }
}

////////////////////////////////////////////////////////////////////////////////
// Load Bridge Defense
////////////////////////////////////////////////////////////////////////////////
// Vertex Starts after accept: id_strandedready
function BridgeDefenseTrigger::onExit(%this)
{   
      %scenario = new SLScenario() {
      stack   = true;
      mapName = "assets/data/missions/sandlot/bridgedefense.mis";
      mapMinimap = "assets/client/ui/minimaps/bridgedefminimap.png";
      mapMain = false;
      
      // Resources
      resourceGold       = "300 0";
      resourceWood       = "250 0";
      resourceFood       = "20 0";
      resourceFoodMax    = "25 0";
      resourceWater      = "0 0";
      resourceWaterMax   = "0 0";
      resourceHappiness  = "80 0";
      
      // Disaster fields
      addDisasterNode        = "0 100 0";
      disasterAnimalRate     = "0 0";
      disasterBanditRate     = "0 0";
      disasterDroughtRate    = "0 0";
      disasterEarthquakeRate = "0 0";
      disasterFamineRate     = "0 0";
      disasterFireRate       = "0 0";
      disasterPlagueRate     = "0 0";
      disasterTornadoRate    = "0 0";
      disasterStack = $DisasterStack::Push;
      
      // Units
      niceLawmen        = true;
      toughLawmen       = true;
      neutralLawmen     = true;
      niceGunslinger    = true;
      toughGunslinger   = true;
      neutralGunslinger = true;
      
      
   };
   
   LoadScenario(%scenario, deactivateMainMapTasks, startBridgeDefenseTasks, resetBridgeDefense);  
}

////////////////////////////////////////////////////////////////////////////////
// Story Arc
////////////////////////////////////////////////////////////////////////////////
// Vertex Complete after: BridgeDefenseComplete,DeadMineComplete,BadSeedComplete,HopeRescueComplete
function storyPlaceDynamite(%objList)
{
   if(%objList.getSize() == 0) {
      return false;
   }
   
   %object = %objList.getRandomObject();
      
   // Get position for tnt
   %pos  = %object.getPosition();
   if(%object.getType() $= "SheriffsOffice") {
      %tntPos[0] = VectorAdd(%pos, "5 0 0");
      %tntPos[1] = VectorAdd(%pos, "0 5 0");
      %tntPos[2] = VectorAdd(%pos, "-3 5 0");
   }
   else if(%object.getType() $= "Farm" || %object.getType() $= "Ranch") {
      %tntPos[0] = VectorAdd(%pos, "7 5 0");
      %tntPos[1] = VectorAdd(%pos, "5 5 0");
      %tntPos[2] = VectorAdd(%pos, "-2 5 0");
   }
   else {
      return false;
   }
   
   // Spawn the tnt
   %object.setName("tntbldg");
   %obj = tsCreateObj("Dynamite", "", "", %tntPos[0], "");
   %obj.setName("spytnt1");
   %obj = tsCreateObj("Dynamite", "", "", %tntPos[1], "");
   %obj.setName("spytnt2");
   %obj = tsCreateObj("Dynamite", "", "", %tntPos[2], "");
   %obj.setName("spytnt3");
   return true;
}
function StoryArcTrigger::onExit(%this)
{
   Parent::onExit(%this);   
   tsSendTaskPopUpDlg("ID_TASK_Story", "id_storyarc", $TaskButton::Okay, "herocharacter", "id_storyarc");
}
function StoryArcTntPlace::onEnter(%this)
{
   echo("StoryArcTntPlace::onEnter");
   Parent::onEnter(%this);
   %objList = tsCreateObjList();
   
   // Find Sheriffs Office
   slgGetServerBuildingListMatch(
      "SheriffsOffice", 
      $OST_PLAYER, 
      $BuildingState::Production, 
      %objList
      );
   // Done if true
   if(storyPlaceDynamite(%objList)) {
      tsCompleteVertexes("MainmapTasks", "StoryArcTntPlace");
      tsDestroyObjList(%objList);
      return;
   }
   
   // Try farm
   slgGetServerBuildingListMatch(
      "Farm", 
      $OST_PLAYER, 
      $BuildingState::Production, 
      %objList
      );
   // Done if true
   if(storyPlaceDynamite(%objList)) {
      tsCompleteVertexes("MainmapTasks", "StoryArcTntPlace");
      tsDestroyObjList(%objList);
      return;
   }
   
   // Try ranch
   slgGetServerBuildingListMatch(
      "Ranch", 
      $OST_PLAYER, 
      $BuildingState::Production, 
      %objList
      );
   // Done if true
   if(storyPlaceDynamite(%objList)) {
      tsCompleteVertexes("MainmapTasks", "StoryArcTntPlace");
      tsDestroyObjList(%objList);
      return;
   }
   
   // Didn't find anything, wait until it is created
   tsDestroyObjList(%objList);
}
function StoryArcTntPlace::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
   // Check for function completion and complete vertex if one of the buildings
   // (sheriff office, farm, or ranch) has been created
   for(%i = 0; %i < 3; %i++) {
      if(%this.isFunctionComplete($TSF_CREATE, %i)) {
         // Done if true
         if(storyPlaceDynamite(tsGetObjListFromMsg(%msg, %params))) {
            tsCompleteVertexes("MainmapTasks", "StoryArcTntPlace");
            return;
         }
      }
   }
}
function StoryArcTntPlace::onExit(%this)
{
   // Move camera to building
   echo("StoryArcTntPlace::onExit");
   Parent::onExit(%this);
   tsMoveCameraToObject("tntbldg", false);
}
function StoryArcWaitForCamera::onUpdate(%this)
{
   Parent::onUpdate(%this);
   
   // Wait for camera until it reaches its destination
   if(!tsIsCameraMoving())
   {
      tsCompleteVertexes("MainmapTasks", "StoryArcWaitForCamera");
   }
}
function StoryArcMoveSpy::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Convert spy and move him to tnt building (what if there is no citizen?)
   %teamList = tsCreateObjList();
   %typeList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %teamList.getTypeList("MaleCiv", %typeList);
   if(%typeList.getSize() <= 0)
   {
      %teamList.getTypeList("FemaleCiv", %typeList);
   }
   if(%typeList.getSize() <= 0)
   {
      // Spawn a citizen
      %bldg = slgQueryInterface("tntbldg", $CID_BUILDING);
      %spy = tsCreateObj("FemaleCiv", "", $OST_NEUTRAL, %bldg.getDoor());
   }
   else
   {
      %spy = %typeList.getRandomObject();
   }
   
   // Convert team and move to target
   %spy.setName("townspy");
   tsSkinObj(%spy, "default");
   tsConvertObjTeam(%spy, $OST_NEUTRAL);
   tsMoveObjToTarget(%spy, "tntbldg");
   
   tsDestroyObjList(%teamList);
   tsDestroyObjList(%typeList);
}
function StoryArcMoveSpy::onUpdate(%this)
{
   Parent::onUpdate(%this);
   %cmpAI = slgQueryInterface(townspy.getId(), $CID_AI);
   if(!IsFollowingPath(%cmpAI) && IsAtDestination(%cmpAI))
   {
      tsCompleteVertexes("MainmapTasks", "StoryArcMoveSpy");
   }
}
function StoryArcPanToSpy::onEnter(%this)
{
   Parent::onEnter(%this);
   tsMoveCameraToObject("townspy", false);
}
function StoryArcPanToSpy::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("MainmapTasks", "StoryArcPanToSpy");
   }
}
function StoryArcSpyDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   tsSendTaskPopUpDlg("ID_TASK_Story", "id_townspythreat", $TaskButton::Okay, "townspy", "id_townspythreat");
}
function StoryArcPanBackToBldg::onEnter(%this)
{
   Parent::onEnter(%this);
   tsMoveCameraToObject("tntbldg", false);
}
function StoryArcPanBackToBldg::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("MainmapTasks", "StoryArcPanBackToBldg");
   }
}
function StoryArcSpyLightTnt::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Start particle fx
   tsStartObjParticleFx("spytnt1", "dynamite");
   tsStartObjParticleFx("spytnt2", "dynamite");
   tsStartObjParticleFx("spytnt3", "dynamite");
   tntbldg.health = 0;
   
   // Hide dynamite
   tsShowMesh("spytnt1", false);
   tsShowMesh("spytnt2", false);
   tsShowMesh("spytnt3", false);
}
function StoryArcSpyLightTnt::onExit(%this)
{
   Parent::onExit(%this);
   
   // Destroy dynamite
   tsRemoveObj("spytnt1");
   tsRemoveObj("spytnt2");
   tsRemoveObj("spytnt3");
}
function StoryArcSpyAttacks::onUpdate(%this)
{
   Parent::onEnter(%this);
   
   // Spy attacks hero
   %cmpChar = slgQueryInterface(townspy.getId(), $CID_CHARACTER);
   if(%cmpChar.getDataBlock().gender == $GENDER_MALE)
   {
      %type = Malebandit;
   }
   else
   {
      %type = Femalebandit;
   }
   %obj = tsCreateObj(%type, townspy.name, $OST_BANDIT, townspy.getPosition(), "townspyclone");
   %obj.setName("townspyclone");
   %obj = tsCreateObj(%type, townspy.name, $OST_NEUTRAL, townspy.getPosition());
   %name = townspy.getName();
   townspy.DeleteObject();
   %obj.setName(%name);
   %obj.showMesh(false);
   
   
   // Update quest log
   tsAddQuestToTracker(true, "Town Traitor", "", "Capture the Citizen who dynamited your town.");
   tsReadyQuest("Town Traitor");
   tsAddTaskToTracker("Town Traitor", "Capture the traitor.", "Catch the traitor who dynamited your town.");
   tsCompleteVertexes("MainmapTasks", "StoryArcSpyAttacks");
}
function StoryArcSpyCloneExists::onExit(%this)
{
   Parent::onExit(%this);
   //tsStartBanditAttack("townspyclone", "HeroCharacter"); 
}
function StoryArcSpyCloneDefeat::onUpdate(%this)
{
   Parent::onUpdate(%this);
   
   // Set new position for town spy
   %pos = townspyclone.getPosition();
   townspy.setPosition(getWord(%pos, 0), getWord(%pos, 1));
}
function StoryArcSpyCloneDefeat::onExit(%this)
{
   Parent::onExit(%this);
   
   // Update quest log
   tsCompleteTaskInTracker("Town Traitor", "Capture the traitor.");
}
function StoryArcSpyReappears::onExit(%this)
{
   Parent::onExit(%this);
   tsShowMesh("townspy", true);
   tsShowMesh("townspyclone", false);
}
function StoryArcSpyPleads::onExit(%this)
{
   Parent::onExit(%this);
   
   // Dialog from town spy
   tsSendTaskPopUpDlg("ID_TASK_Story", "id_townspyplea", $TaskButton::More, "townspy");
   tsSendTaskPopUpDlg("ID_TASK_Story", "id_townspybargain", $TaskButton::Okay, "townspy", "id_townspybargain");
}
function EscortLoad::onEnter(%this)
{
   // Accept for escort mission
   Parent::onEnter(%this);
   tsSendTaskClickDlg("ID_TASK_Story", "id_townspysafety", $TaskButton::Accept, "townspy", "id_townspysafety");
}
function BanditSpyLoad::onEnter(%this)
{
   // Accept for bandit spy mission
   Parent::onEnter(%this);
   tsSendTaskClickDlg("ID_TASK_Story", "id_findotherspy", $TaskButton::Accept, "HeroCharacter", "id_findotherspy");
}

////////////////////////////////////////////////////////////////////////////////
// Bandit Spy
////////////////////////////////////////////////////////////////////////////////
// Loads Bandit Spy on Accept of id_findotherspy
function BanditSpyLoad::onExit(%this)
{   
   // Create spy puzzle scenario
   %scenario = new SLScenario()
   {
      stack   = true;
      mapMain = false;
      mapName = "assets/data/missions/sandlot/spypuzzle.mis";
      mapMinimap = "assets/client/ui/minimaps/spyminimap.png";
      
      // for all resources used for purchasing to zero
      // max out food (set to something higher than max)
      resourceGold = "0 0";
      resourceWood = "0 0";
      resourceFood = "20 0";
      resourceWater = "0 0";
      resourceWaterMax = "0";
      resourceHappiness = "80 0";
      
      // turn off all disasters
      disasterStack = $DisasterStack::Push;
      addDisasterNode = "0 60 0";
   
   };
   
   LoadScenario(%scenario, deactivateMainMapTasks, startSpyPuzzleTasks, quitSpyPuzzleTasks); 
}

////////////////////////////////////////////////////////////////////////////////
// Escort
////////////////////////////////////////////////////////////////////////////////
// Loads Escort on Accept of id_townspysafety
function EscortLoad::onExit(%this)
{   
   //Clear Globals  
   $escortsex = "";
   $escortname = "";
   %spyid = townspy.getID();
   if( stricmp(%spyid.getType(),"Femalebandit") == 0)
   {
      $escortsex = "female";
   }
   else{
      $escortsex = "male";
   }
   $escortname = townspy.name;
   %scenario = new SLScenario()
   {
      stack   = true;
      mapMain = false;
      mapName = "assets/data/missions/sandlot/escort.mis";
      mapMinimap = "assets/client/ui/minimaps/escortminimap.png";
      
      // for all resources used for purchasing to zero
      resourceGold = "0 1";
      resourceWood = "0 1";
      resourceFood = "20 0";
      resourceFoodMax = "20";
      resourceWater = "0 0";
      resourceWaterMax = "0";
      resourceHappiness = "80 0";
      
      // turn off all disasters
      disasterStack = $DisasterStack::Push;
      addDisasterNode = "0 60 0";
      
      // certain characters can carry over
      niceLawmen = true;
      toughLawmen = true;
      neutralLawmen = true;
   };
      
   LoadScenario(%scenario, deactivateMainMapTasks, startEscortTasks, resetEscortTasks); 
}

////////////////////////////////////////////////////////////////////////////////
// Deactivation for main map tasks
////////////////////////////////////////////////////////////////////////////////

function deactivateMainMapTasks()
{
   tsEndTask("MainmapTasks");
   tsEndTask("StartTasks");
   tsEndTask("GeneralTasks");
}

// Vertex Completes after Escort and Bandit Spy are completed
function FinalTaskMap1::onExit(%this)
{
  tsSendTaskClickDlg("ID_TASK_EndMap", "id_EndtaskStart", $TaskButton::Okay, "herocharacter", "id_EndtaskStart"); 
}
//
function FinalTaskIntroDialog::onExit(%this)
{
  tsSendTaskPopUpDlg("ID_TASK_EndMap", "id_EndtaskQuest", $TaskButton::Okay, "herocharacter", "id_EndtaskQuest");
}
function FinalTaskOutpostcheck::onExit(%this)
{
   //check if Outpost task has been built
   %outpostCnt = 0;
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("outpost", "bldg", %objList);
   for(%index = 0; %index < %objList.getSize(); %index++)
   {
      %mapobject = %objList.getID(%index);
      if(%mapobject.getTeam() == "1")
      {  
         %teamObj = %objList.getID(%index);
         %outpostCnt++;
      }
   }
   tsDestroyObjList(%objList);
   // check for trainstation
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("trainstation", "bldg", %objList);
   for(%index = 0; %index < %objList.getSize(); %index++)
   {
      %mapobject = %objList.getID(%index);
      if(%mapobject.getTeam() == "1")
      {  
         %teamObj = %objList.getID(%index);
         %outpostCnt++;
      }
   }
   tsDestroyObjList(%objList);
   if(%outpostCnt > 0)
   {
      //Quest log
      tsAddQuestToTracker(true, $map1FinalQuest, "", "The Mad Russian is hiding out at a Bandit camp up in Gunslinger Gulch. Collect the necessary resources and head out after him.", "Reward: 50 Experience");
      tsReadyQuest($map1FinalQuest);
      tsAddTaskToTracker($map1FinalQuest, "Collect 500 Gold, 500 Wood, and 20 Food.", "Collect 500 Gold, 500 Wood, and 20 Food.");
      TaskModifier.strMarkVertex("MainmapTasks", "FinalTaskwagon", $TSV_AVAIL);
   }
   else
   {
      //Quest log
      tsAddQuestToTracker(true, $map1FinalQuest, "", "The Mad Russian is hiding out at a Bandit camp up in Gunslinger Gulch. Collect the necessary resources and head out after him.", "Reward: 50 Experience");
      tsReadyQuest($map1FinalQuest);
      tsAddTaskToTracker($map1FinalQuest, "Build an Outpost.", "It's a long way to the bandit camp, you'll need a solid trade route to get there.");
      TaskModifier.strMarkVertex("MainmapTasks", "FinalBuildOutpost", $TSV_AVAIL);
   }
}
function FinalBuildOutpost::onExit(%this)
{
   tsAddTaskToTracker($map1FinalQuest, "Collect 500 Gold, 500 Wood, and 20 Food.", "Collect 500 Gold, 500 Wood, and 20 Food.");
   tsCompleteTaskInTracker($map1FinalQuest, "Build an Outpost.");
}
function FinalTaskwagon::onExit(%this)
{
  %dialog = tsCreateTaskDlgData("ID_TASK_EndMap", true, true, "Id_Loadmap2Accept");
   tsAddTaskDialog("Id_Loadmap2Accept", %dialog);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dialog);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dialog);
   tsAddAcceptCost($Resource::Gold, 500, %dialog);
   tsAddAcceptCost($Resource::Wood, 500, %dialog);
   tsAddAcceptCost($Resource::Food, 20, %dialog);
   tsSendTaskDlgMsg(%dialog, "herocharacter");
   tsDestroyTaskDlgData(%dialog);
}
function LoadMap2Campaign::onExit(%this)
{
   // check which outpost tasks need to be marked unavailable
   // for campaign 2 (starts off as a platform)
   if (OutpostTaskGoldTrigger.isAvailable() == true)
   {
      TaskModifier.strMarkVertex("OutpostTasks", "OutpostTaskGoldTrigger", $TSV_UNAVAIL);
   }
   if (OutpostTaskWoodTrigger.isAvailable() == true)
   {
      TaskModifier.strMarkVertex("OutpostTasks", "OutpostTaskWoodTrigger", $TSV_UNAVAIL);
   }
   if (OutpostTaskFoodTrigger.isAvailable() == true)
   {
      TaskModifier.strMarkVertex("OutpostTasks", "OutpostTaskFoodTrigger", $TSV_UNAVAIL);
   }
   
   Parent::onExit(%this);
   tsCompleteTaskInTracker($map1FinalQuest, "Collect 500 Gold, 500 Wood, and 20 Food.");
   %scenario = new SLScenario()
   {
     stack = false;
     mapName = "assets/data/missions/sandlot/campaign2.mis";
     mapMinimap = "assets/client/ui/minimaps/campaign2minimap.png";
     mapMain = true;
     
     // Resources
      resourceGold       = "500 0";
      resourceWood       = "500 0";
      resourceFood       = "20 0";
      resourceFoodMax    = "20";
      resourceWater      = "0 0";
      resourceWaterMax   = "0";
      resourceHappiness  = "80 0";
      addDisasterNode = "0 70 2";
      
      // frequency pool, respawning time      
      disasterStack = $DisasterStack::Push;
   };
   
   LoadScenario(%scenario, deactivateMainMapTasks, Campaign2StartTasks, "");
   
   // initialize the world map images
   tutorialworldmap.visible = false;
   campaign1worldmap.visible = false;
   campaign2worldmap.visible = true;
   fullworldmap.visible = false;
   
   // update the campaign icons
   campaign1worldicon.visible = true;
   
   // update the satellite icons
   SetCampaign2Satellites(true);
}

//------------------------------------------------------------------------------
